/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.peer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.internal.peer.ExitPolicy;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerCharacterCloser
implements VerifyKeyListener,
ILinkedModeListener {
    private ITextViewer textViewer;
    private final String CATEGORY = this.toString();
    private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack<BracketLevel> fBracketLevelStack = new Stack();
    private List<Character> pairs = Collections.emptyList();
    private boolean autoInsertEnabled = true;
    private boolean autoWrapEnabled = true;

    public PeerCharacterCloser(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public void install() {
        this.textViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || !this.isAutoInsertEnabled() || this.isModifierKey(event.keyCode)) {
            return;
        }
        IDocument document = this.textViewer.getDocument();
        Point selection = this.textViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            char nextChar;
            String scope = this.getScopeAtOffset(document, offset);
            this.pairs = this.getPairs(scope);
            if (this.pairs == null || this.pairs.size() <= 0 || !this.isAutoInsertCharacter(event.character)) {
                return;
            }
            if (length > 0 && this.isAutoWrapEnabled()) {
                this.wrapSelection(event, document, offset, length);
                return;
            }
            if (document.getLength() > offset && Character.isJavaIdentifierPart(nextChar = document.getChar(offset))) {
                return;
            }
            if (this.isUnclosedPair(event, document, offset)) {
                return;
            }
            char closingCharacter = this.getPeerCharacter(event.character);
            if (this.unpairedClose(event.character, closingCharacter, document, offset)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(event.character);
            buffer.append(closingCharacter);
            if (offset == document.getLength()) {
                String delim = null;
                if (document instanceof IDocumentExtension4) {
                    delim = ((IDocumentExtension4)document).getDefaultLineDelimiter();
                }
                if (delim == null) {
                    delim = System.getProperty("line.separator", "\r\n");
                }
                buffer.append(delim);
            }
            document.replace(offset, length, buffer.toString());
            BracketLevel level = new BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            level.fFirstPosition = new Position(offset, 1);
            level.fSecondPosition = new Position(offset + 1, 1);
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, this.textViewer);
            level.fUI.setSimpleMode(true);
            level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(this.textViewer, closingCharacter, PeerCharacterCloser.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
            level.fUI.setExitPosition(this.textViewer, offset + 2, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            IRegion newSelection = level.fUI.getSelectedRegion();
            this.textViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = false;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private boolean isModifierKey(int keyCode) {
        switch (keyCode) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 27: 
            case 127: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected List<Character> getPairs(String scope) {
        ScopeFilter filter = new ScopeFilter(scope);
        List pairs = BundleManager.getInstance().getPairs((IModelFilter)filter);
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<IScopeSelector, SmartTypingPairsElement> map = new HashMap<IScopeSelector, SmartTypingPairsElement>();
        for (SmartTypingPairsElement pe : pairs) {
            IScopeSelector ss = pe.getScopeSelector();
            if (ss == null) continue;
            map.put(ss, pe);
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), (String)scope);
        SmartTypingPairsElement yay = (SmartTypingPairsElement)map.get(bestMatch);
        if (yay == null) {
            return Collections.emptyList();
        }
        return yay.getPairs();
    }

    protected String getScopeAtOffset(IDocument document, int offset) throws BadLocationException {
        if (this.textViewer == null) {
            return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(document, offset);
        }
        return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(this.textViewer, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unpairedClose(char openingChar, char closingCharacter, IDocument document, int offset) {
        try {
            ITypedRegion[] partitions;
            String partition = document.getContentType(offset);
            int index = partition.indexOf(95, 2);
            String prefix = partition.substring(0, index);
            int stackLevel = 0;
            ITypedRegion[] iTypedRegionArray = partitions = this.computePartitioning(document, 0, document.getLength());
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion part = iTypedRegionArray[n2];
                if (!part.getType().contains("_comment") && !part.getType().contains("_string") && part.getType().startsWith(prefix)) {
                    char c;
                    int i;
                    int start = part.getOffset();
                    int end = start + part.getLength();
                    if (offset > start) {
                        String before;
                        int beforeEnd = end;
                        if (offset < end) {
                            beforeEnd = offset;
                        }
                        if ((before = document.get(start, beforeEnd - start)).trim().length() != 0) {
                            i = 0;
                            while (i < before.length()) {
                                c = before.charAt(i);
                                if (c == openingChar && openingChar == closingCharacter) {
                                    ++stackLevel;
                                    stackLevel %= 2;
                                } else if (c == openingChar) {
                                    ++stackLevel;
                                } else if (c == closingCharacter) {
                                    --stackLevel;
                                }
                                ++i;
                            }
                        }
                    }
                    if (offset < end) {
                        int startAfter = start;
                        if (offset > start) {
                            startAfter = offset;
                        }
                        String after = document.get(startAfter, end - startAfter);
                        i = 0;
                        while (i < after.length()) {
                            c = after.charAt(i);
                            if (c == openingChar && openingChar == closingCharacter) {
                                ++stackLevel;
                                stackLevel %= 2;
                            } else if (c == openingChar) {
                                ++stackLevel;
                            } else if (c == closingCharacter && --stackLevel < 0) {
                                return true;
                            }
                            ++i;
                        }
                    }
                }
                ++n2;
            }
            return stackLevel != 0;
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to determine if we have an unclosed pair. Open: ''{0}'', close: ''{1}'', offset: {2}", Character.valueOf(openingChar), Character.valueOf(closingCharacter), offset), (Throwable)e);
            return false;
        }
    }

    protected ITypedRegion[] computePartitioning(IDocument document, int offset, int length) throws BadLocationException {
        return document.computePartitioning(offset, length);
    }

    private boolean isUnclosedPair(VerifyEvent event, IDocument document, int offset) throws BadLocationException {
        char closingCharacter = this.getPeerCharacter(event.character);
        if (closingCharacter != event.character) {
            return false;
        }
        char c = event.character;
        int beginning = 0;
        if (document instanceof IDocumentExtension3) {
            try {
                IDocumentExtension3 ext = (IDocumentExtension3)document;
                ITypedRegion region = this.getPartition(ext, "__dftl_partitioning", offset, false);
                beginning = region.getOffset();
            }
            catch (BadPartitioningException ext) {
                // empty catch block
            }
        }
        String previous = document.get(beginning, offset - beginning);
        boolean open = false;
        int index = -1;
        while ((index = previous.indexOf(c, index + 1)) != -1) {
            open = !open;
            c = open ? closingCharacter : event.character;
        }
        return open;
    }

    protected ITypedRegion getPartition(IDocumentExtension3 ext, String defaultPartitioning, int offset, boolean b) throws BadLocationException, BadPartitioningException {
        return ext.getPartition(defaultPartitioning, offset, b);
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private void wrapSelection(VerifyEvent event, IDocument document, int offset, int length) throws BadLocationException {
        char closingCharacter = this.getPeerCharacter(event.character);
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.character);
        buffer.append(document.get(offset, length));
        buffer.append(closingCharacter);
        document.replace(offset, length, buffer.toString());
        event.doit = false;
    }

    private char getPeerCharacter(char character) {
        int i = 0;
        while (i < this.pairs.size()) {
            if (this.pairs.get(i).charValue() == character) {
                return this.pairs.get(i + 1).charValue();
            }
            i += 2;
        }
        return character;
    }

    private boolean isAutoInsertCharacter(char character) {
        int i = 0;
        while (i < this.pairs.size()) {
            if (this.pairs.get(i).charValue() == character) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public boolean isAutoInsertEnabled() {
        return this.autoInsertEnabled;
    }

    public void setAutoInsertEnabled(boolean autoInsertEnabled) {
        this.autoInsertEnabled = autoInsertEnabled;
    }

    public boolean isAutoWrapEnabled() {
        return this.autoWrapEnabled;
    }

    public void setAutoWrapEnabled(boolean autoWrapEnabled) {
        this.autoWrapEnabled = autoWrapEnabled;
    }

    public void left(LinkedModeModel environment, int flags) {
        final BracketLevel level = this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        final IDocument document = this.textViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                        try {
                            document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                        }
                        catch (BadLocationException e) {
                            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                    if (PeerCharacterCloser.this.fBracketLevelStack.size() == 0) {
                        document.removePositionUpdater(PeerCharacterCloser.this.fUpdater);
                        try {
                            document.removePositionCategory(PeerCharacterCloser.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException e) {
                            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    static class BracketLevel {
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
    }
}

